# Note that for safety, only limited Python modules can be imported. 
# Attempt to import other modules will cause runtime error and the script will not be executed.
# No need to import modules here, allowed modules are already imported.

# Global variable "result" must be declared
# Then the script run result must be assigned to the global variable "result" before exiting from this script
global result

# Input data is passed via variable "inputArgument". No need to declare it, it will be available.

def filter(arg):
    # globalVariables is a dictionary, where some data can be stored which is persisted in memory 
    global globalVariables
    
    # The returned value is array of boolean values. 
    result = []
    
    index = 0
    try:
        # Note: Complete structure of data passed to the function can be viewed in Browser Log file. 
        inputData = json.loads(arg)
        
        # The member field "Nodes" of the passed JSON formatted text argument has a list of objects representing OPC UA nodes.
        # The list "result" must have the same length as this "Nodes" list. If the element is True, then the node will be browsed further. Otherwise, the node will not be browsed.
        nodes = inputData["Nodes"]

        numberOfRecords = len(nodes)
        
        while index < numberOfRecords:
            node = nodes[index]
            nodeId = node["NodeId"]
            
            toSelect = False
            
            bp = node["BrowsePath"]
            # Browse path can be used to judge weither the node should be browsed down or not.
            # For example, to select nodes under `Objects/BuildingAutomation` in Unified Automation OPC UA Demo server, un-comment lines below:
            #if bp == 'Objects' or bp.startswith('Objects/BuildingAutomation'):
            #   toSelect = True

            # Note that variables by default are not browsed, and they are not included into list of nodes passed to this script. 
            # To include variable nodes into list of nodes passed to this script, set server advanced option browseVariablesOnDiscovery to True.
            # To check if the node is a variable node, use NodeClass attribute:
            #isVariable = node["NodeClass"] == "Variable"
            #    toSelect = False;

            if bp.startswith('Objects'): # Browse all nodes below Objects
                toSelect = True

            result.append(toSelect)
            
            index = index + 1
        
        # print("Processed {} nodes".format(index))

    except:
        print("Exception happened")
        pass

    return result

# At return, the global variable "result" must be assigned returned value:
result = filter(inputArgument)

