DROP TABLE IF EXISTS temp_table;
CREATE TABLE temp_table (
	"id"	INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
	"server_id"	INTEGER NOT NULL,
	"display_name"	TEXT NOT NULL,
	"opc_node_id"	TEXT NOT NULL,
	"node_id"	INTEGER NOT NULL,
	"sampling_interval"	REAL DEFAULT -1,
	"publishing_interval"	REAL NOT NULL,
	"queue_size"	INTEGER NOT NULL,
	"discard_oldest"	INTEGER NOT NULL,
	"data_change_trigger"	INTEGER NOT NULL,
	"deadband_type"	INTEGER NOT NULL,
	"deadband_value"	REAL,
	"eu_range" REAL DEFAULT 0,
	"active"	INTEGER NOT NULL,
	"historizing"	INTEGER NOT NULL,
	"readfrom"	INTEGER NOT NULL,
	"readtype"	INTEGER NOT NULL,
	"agentid"	INTEGER NOT NULL,
	"routeid"	INTEGER NOT NULL,
	"targetid"	INTEGER NOT NULL,
	"group_id"	INTEGER,
	"topic" TEXT,
	"tag" TEXT,
	"partition" INTEGER,
	"json"	TEXT,
	"store_expanded_values" INTEGER DEFAULT 0,
	"member_filters" TEXT,
	"browse_name" TEXT,
	"browse_path" TEXT
); 

INSERT INTO temp_table (id,server_id,display_name,opc_node_id,node_id,sampling_interval,publishing_interval,queue_size,discard_oldest,data_change_trigger,deadband_type,deadband_value,eu_range,active,historizing,readfrom,readtype,agentid,routeid,targetid,group_id,topic,tag,partition,json,store_expanded_values,member_filters,browse_name,browse_path) SELECT id,server_id,display_name,opc_node_id,node_id,sampling_interval,publishing_interval,queue_size,discard_oldest,data_change_trigger,deadband_type,deadband_value,eu_range,active,historizing,readfrom,readtype,agentid,routeid,targetid,group_id,topic,tag,partition,json,store_expanded_values,member_filters,browse_name,browse_path FROM loggingNodes;

-- Drop the original table
DROP TABLE loggingNodes;
-- Rename the temporary table to the original table name
ALTER TABLE temp_table RENAME TO loggingNodes;

DROP TABLE IF EXISTS temp_table2;

CREATE TABLE temp_table2 (
	"id"	INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
	"name"	TEXT,
	"tag" TEXT,
	"description"	TEXT,
	"sampling_interval"	REAL,
	"publishing_interval"	REAL,
	"queue_size"	INTEGER,
	"discard_oldest"	INTEGER,
	"data_change_trigger"	INTEGER,
	"deadband_type"	INTEGER,
	"deadband_value"	REAL,
	"eu_range" REAL DEFAULT 0,
	"active"	INTEGER DEFAULT 1,
	"read_from"	INTEGER,
	"read_type"	INTEGER,
	"store_expanded_values" INTEGER DEFAULT 0,
	"json"	TEXT);
	
INSERT INTO temp_table2 (id,name,tag,description,sampling_interval,publishing_interval,queue_size,discard_oldest,data_change_trigger,deadband_type,deadband_value,eu_range,active,read_from,read_type,store_expanded_values,json) SELECT id,name,tag,description,sampling_interval,publishing_interval,queue_size,discard_oldest,data_change_trigger,deadband_type,deadband_value,eu_range,active,read_from,read_type,store_expanded_values,json FROM variable_groups;

DROP TABLE variable_groups;
-- Rename the temporary table to the original table name
ALTER TABLE temp_table2 RENAME TO variable_groups;