CREATE TABLE IF NOT EXISTS "servers" (
	"id"	INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
	"name"	TEXT NOT NULL,
	"endpoint_url"	TEXT NOT NULL,
	"timeout"	INTEGER NOT NULL,
	"active"	INTEGER NOT NULL,
	"security_mode"	INTEGER NOT NULL,
	"modified_at" INTEGER,
	"modified_by" TEXT,
	"tag" TEXT,
	"json"	TEXT NOT NULL,
	"nsm" TEXT
);
ALTER TABLE "servers" ADD COLUMN "modified_at" INTEGER;
ALTER TABLE "servers" ADD COLUMN "modified_by" TEXT;
ALTER TABLE "servers" ADD COLUMN "tag" TEXT;
ALTER TABLE "servers" ADD COLUMN "nsm" TEXT;
CREATE TABLE IF NOT EXISTS "loggingNodes" (
	"id"	INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
	"server_id"	INTEGER NOT NULL,
	"display_name"	TEXT NOT NULL,
	"opc_node_id"	TEXT NOT NULL,
	"node_id"	INTEGER NOT NULL,
	"sampling_interval"	REAL DEFAULT -1,
	"publishing_interval"	REAL NOT NULL,
	"queue_size"	INTEGER NOT NULL,
	"discard_oldest"	INTEGER NOT NULL,
	"data_change_trigger"	INTEGER NOT NULL,
	"deadband_type"	INTEGER NOT NULL,
	"deadband_value"	REAL,
	"eu_range" REAL DEFAULT 0,
	"active"	INTEGER NOT NULL,
	"historizing"	INTEGER NOT NULL,
	"readfrom"	INTEGER NOT NULL,
	"readtype"	INTEGER NOT NULL,
	"agentid"	INTEGER NOT NULL,
	"routeid"	INTEGER NOT NULL,
	"targetid"	INTEGER NOT NULL,
	"group_id"	INTEGER,
	"topic" TEXT,
	"tag" TEXT,
	"partition" INTEGER,
	"json"	TEXT,
	"store_expanded_values" INTEGER DEFAULT 0,
	"member_filters" TEXT,
	"browse_name" TEXT,
	"browse_path" TEXT
); 
ALTER TABLE "loggingNodes" RENAME COLUMN "Id" TO "id";

ALTER TABLE "loggingNodes" RENAME COLUMN "ServerId" TO "server_id";

ALTER TABLE "loggingNodes" RENAME COLUMN "Description" TO "display_name";

ALTER TABLE "loggingNodes" RENAME COLUMN "OpcNodeId" TO "opc_node_id";

ALTER TABLE "loggingNodes" RENAME COLUMN "NodeId" TO "node_id";

ALTER TABLE "loggingNodes" RENAME COLUMN "SamplingInterval" TO "sampling_interval";

ALTER TABLE "loggingNodes" RENAME COLUMN "PublishingInterval" TO "publishing_interval";

ALTER TABLE "loggingNodes" RENAME COLUMN "QueueSize" TO "queue_size";

ALTER TABLE "loggingNodes" RENAME COLUMN "DiscardOldest" TO "discard_oldest";

ALTER TABLE "loggingNodes" RENAME COLUMN "DataChangeTrigger" TO "data_change_trigger";

ALTER TABLE "loggingNodes" RENAME COLUMN "DeadbandType" TO "deadband_type";

ALTER TABLE "loggingNodes" RENAME COLUMN "DeadbandValue" TO "deadband_value";

ALTER TABLE "loggingNodes" ADD COLUMN "group_id" INTEGER DEFAULT 1;

ALTER TABLE "loggingNodes" ADD COLUMN "topic" TEXT;

ALTER TABLE "loggingNodes" ADD COLUMN "tag" TEXT;

ALTER TABLE "loggingNodes" ADD COLUMN "partition" INTEGER;

ALTER TABLE "loggingNodes" ADD COLUMN eu_range REAL DEFAULT 0;

ALTER TABLE "loggingNodes" ADD COLUMN store_expanded_values INTEGER DEFAULT 0;

ALTER TABLE "loggingNodes" ADD COLUMN member_filters TEXT;
ALTER TABLE "loggingNodes" ADD COLUMN browse_name TEXT;
ALTER TABLE "loggingNodes" ADD COLUMN browse_path TEXT;

CREATE TABLE IF NOT EXISTS variable_groups (
	"id"	INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
	"name"	TEXT,
	"tag" TEXT,
	"description"	TEXT,
	"sampling_interval"	REAL,
	"publishing_interval"	REAL,
	"queue_size"	INTEGER,
	"discard_oldest"	INTEGER,
	"data_change_trigger"	INTEGER,
	"deadband_type"	INTEGER,
	"deadband_value"	REAL,
	"eu_range" REAL DEFAULT 0,
	"active"	INTEGER DEFAULT 1,
  "update_variables" INTEGER DEFAULT 0,
	"read_from"	INTEGER,
	"read_type"	INTEGER,
	"store_expanded_values" INTEGER DEFAULT 0,
	"json"	TEXT);

ALTER TABLE variable_groups ADD COLUMN active INTEGER DEFAULT 1;
ALTER TABLE variable_groups ADD COLUMN update_variables INTEGER DEFAULT 0;
ALTER TABLE variable_groups ADD COLUMN eu_range REAL DEFAULT 0;
ALTER TABLE variable_groups ADD COLUMN store_expanded_values INTEGER DEFAULT 0;

CREATE TABLE IF NOT EXISTS scripts (
	"id"	INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
	"type" INTEGER NOT NULL, 
	"name"	TEXT,
	"description" TEXT,
	"code"	TEXT,
	"json"	TEXT,
	"modified_at", INTEGER,
	"modified_by", TEXT);
	
ALTER TABLE scripts ADD COLUMN modified_at INTEGER DEFAULT NULL;	
ALTER TABLE scripts ADD COLUMN "modified_by" TEXT;
	
CREATE TABLE IF NOT EXISTS "tsdbs" (
	"id"	INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
	"name"	TEXT NOT NULL,
	"type"	TEXT NOT NULL,
	"host"	TEXT,
	"port"	INTEGER,
	"user_name"	TEXT,
	"password"	TEXT,
	"path"	TEXT,
	"init_script"	TEXT,
	"connection_timeout"	INTEGER,
	"use_secured_mode"	INTEGER,
	"max_read_values"	INTEGER,
	"max_write_values"	INTEGER,
	"timeout"	INTEGER,
	"topic_name_generation_mode" INTEGER,
	"key_name_generation_mode" INTEGER,
	"max_queue_size"	INTEGER,
	"max_interval"	INTEGER,
	"modified_at" INTEGER,
	"modified_by" TEXT,
	"json"	TEXT
);
CREATE TABLE IF NOT EXISTS "instances" (	
		"id" TEXT NOT NULL PRIMARY KEY,
		"name" TEXT,
    "ha_cluster_id" TEXT,
    "ha_node_id" TEXT,
    "ha_mode" INTEGER,
		"web_protocol" TEXT,
		"web_host" TEXT,
		"web_host_resolved" TEXT,
		"web_port" INTEGER,
		"web_ip_address" TEXT,
		"web_doc_root" TEXT,
		"web_number_of_threads" INTEGER,
		"config_id" INTEGER,
		"tsdb_id" INTEGER NOT NULL,
		"collector_enabled" INTEGER,
		"forwarder_enabled" INTEGER,
		"rest_enabled" INTEGER,
		"config_enabled" INTEGER,
		"app_log_level" INTEGER,
		"app_log_file_max_size" INTEGER,
		"app_log_file_max_number" INTEGER,
		"app_log_file_name" TEXT,
		"sdk_log_level" INTEGER,
		"sdk_log_file_max_size" INTEGER,
		"sdk_log_file_max_number" INTEGER,
		"sdk_log_file_name" TEXT,
		"sdk_io_threads" INTEGER,
		"sdk_timer_threads" INTEGER,
		"sdk_callback_threads" INTEGER,
		"sdk_pki_root_folder" TEXT,
		"sdk_self_signed_certificate" INTEGER,
		"state" INTEGER,
		"link_to_db" TEXT,
		"link_to_grafana" TEXT,
		"start_time" TEXT,
		"last_update_time" TEXT,
		"stop_time" TEXT,
		"modified_at" INTEGER,
		"modified_by" TEXT,
		"json" TEXT
);
ALTER TABLE "instances" ADD COLUMN "ha_cluster_id" TEXT;
ALTER TABLE "instances" ADD COLUMN "ha_node_id" TEXT;
ALTER TABLE "instances" ADD COLUMN "ha_mode" INTEGER;
ALTER TABLE "instances" ADD COLUMN "forwarder_enabled" INTEGER;
ALTER TABLE "instances" ADD COLUMN "web_host_resolved" TEXT;
ALTER TABLE "instances" ADD COLUMN "sdk_timer_threads" INTEGER;
ALTER TABLE "instances" ADD COLUMN "sdk_self_signed_certificate" INTEGER;

CREATE TABLE IF NOT EXISTS "config_servers" (		
	"id" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
	"config_id" INTEGER NOT NULL,
	"server_id" INTEGER NOT NULL
);
CREATE TABLE IF NOT EXISTS "configs" (	
	"id" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
	"name" TEXT NOT NULL,
	"modified_at" INTEGER,
	"modified_by" TEXT,
	"json" TEXT
);
CREATE TABLE IF NOT EXISTS "iam_settings" (
	"id"	INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
	"type"	TEXT NOT NULL,
	"session_timeout" INTEGER,
	"json"	TEXT NOT NULL
);
CREATE TABLE IF NOT EXISTS "iam_users" (
	"id" TEXT NOT NULL PRIMARY KEY,
	"name"	TEXT NOT NULL,
	"code1" TEXT NOT NULL,
	"code2" TEXT NOT NULL,
	"active" INTEGER,
	"role" TEXT NOT NULL
);