DO $$
BEGIN
-- create table Servers if not exists:
IF NOT EXISTS (SELECT 1 FROM pg_tables WHERE schemaname = 'public' AND tablename = 'servers')
	THEN CREATE TABLE "servers" (
		"id" SERIAL NOT NULL PRIMARY KEY,
		"name" TEXT NOT NULL,
		"endpoint_url" TEXT NOT NULL,
		"timeout" INTEGER NOT NULL,
		"active" BOOLEAN NOT NULL,
		"security_mode" INTEGER NOT NULL,
		"modified_at"  timestamp without time zone,
		"modified_by" TEXT,
		"tag" TEXT,
		"json" TEXT,
		"nsm" TEXT);
ELSE
BEGIN
-- If the table already exists, then add new columns if required:
BEGIN
	ALTER TABLE "servers" ADD COLUMN "modified_at" timestamp without time zone;
EXCEPTION
  WHEN duplicate_column THEN RAISE NOTICE 'Verified that column modified_at exists in table servers.';
END;
BEGIN
	ALTER TABLE "servers" ADD COLUMN "modified_by" TEXT;
EXCEPTION
  WHEN duplicate_column THEN RAISE NOTICE 'Verified that column modified_by exists in table servers.';
END;

BEGIN
	ALTER TABLE "servers" ADD COLUMN "tag" TEXT;
EXCEPTION
  WHEN duplicate_column THEN RAISE NOTICE 'Verified that column tag exists in table servers.';
END;
BEGIN
	ALTER TABLE "servers" ADD COLUMN "nsm" TEXT;
EXCEPTION
  WHEN duplicate_column THEN RAISE NOTICE 'Verified that column nsm exists in table servers.';
END;
END;
END IF;

-- create table loggingNodes if not exists:
IF NOT EXISTS (SELECT 1 FROM pg_tables WHERE schemaname = 'public' AND tablename = 'loggingNodes')
	THEN CREATE TABLE "loggingNodes" (
	"id" SERIAL NOT NULL PRIMARY KEY,
	"server_id" INTEGER NOT NULL,
	"display_name" TEXT NOT NULL,
	"opc_node_id" TEXT NOT NULL,
	"node_id" INTEGER NOT NULL,
	"sampling_interval" double precision NOT NULL,
	"publishing_interval" double precision NOT NULL,
	"queue_size" SMALLINT NOT NULL,
	"discard_oldest" BOOLEAN NOT NULL,
	"data_change_trigger" INTEGER NOT NULL,
	"deadband_type" INTEGER NOT NULL,
	"deadband_value" REAL NOT NULL,
	"eu_range" double precision NOT NULL,
	"active" BOOLEAN NOT NULL,
	"historizing" BOOLEAN NOT NULL,
	"readfrom" SMALLINT NOT NULL,
	"readtype" SMALLINT NOT NULL,
	"agentid" INTEGER NOT NULL,
	"routeid" INTEGER NOT NULL,
	"targetid" INTEGER NOT NULL,
	"group_id" INTEGER,
	"topic" TEXT,
	"tag" TEXT,
	"partition" INTEGER,
	"json" TEXT,
	"store_expanded_values" INTEGER,
	"member_filters" TEXT,
	"browse_name" TEXT,
	"browse_path" TEXT);
ELSE
	BEGIN
		ALTER TABLE public."loggingNodes" RENAME COLUMN "Id" TO "id";
		ALTER TABLE public."loggingNodes" RENAME COLUMN "ServerId" TO "server_id";
		ALTER TABLE public."loggingNodes" RENAME COLUMN "Description" TO "display_name";
		ALTER TABLE public."loggingNodes" RENAME COLUMN "OpcNodeId" TO "opc_node_id";
		ALTER TABLE public."loggingNodes" RENAME COLUMN "NodeId" TO "node_id";
		ALTER TABLE public."loggingNodes" RENAME COLUMN "SamplingInterval" TO "sampling_interval";
		ALTER TABLE public."loggingNodes" RENAME COLUMN "PublishingInterval" TO "publishing_interval";
		ALTER TABLE public."loggingNodes" RENAME COLUMN "QueueSize" TO "queue_size";
		ALTER TABLE public."loggingNodes" RENAME COLUMN "DiscardOldest" TO "discard_oldest";
		ALTER TABLE public."loggingNodes" RENAME COLUMN "DataChangeTrigger" TO "data_change_trigger";
		ALTER TABLE public."loggingNodes" RENAME COLUMN "DeadbandType" TO "deadband_type";
		ALTER TABLE public."loggingNodes" RENAME COLUMN "DeadbandValue" TO "deadband_value";
	EXCEPTION
		WHEN undefined_column THEN RAISE NOTICE 'Column names look normal (all lower case).';
	END;

	BEGIN
		BEGIN
			ALTER TABLE "loggingNodes" ADD COLUMN "group_id" INTEGER;
		EXCEPTION
			WHEN duplicate_column THEN RAISE NOTICE 'Verified that column group_id exists in table loggingNodes.';
		END;
		BEGIN
			ALTER TABLE "loggingNodes" ADD COLUMN "topic" TEXT;
		EXCEPTION
			WHEN duplicate_column THEN RAISE NOTICE 'Verified that column topic exists in table loggingNodes.';
		END;
		BEGIN
			ALTER TABLE "loggingNodes" ADD COLUMN "tag" TEXT;
		EXCEPTION
			WHEN duplicate_column THEN RAISE NOTICE 'Verified that column tag exists in table loggingNodes.';
		END;
		BEGIN
			ALTER TABLE "loggingNodes" ADD COLUMN "partition" INTEGER;
		EXCEPTION
			WHEN duplicate_column THEN RAISE NOTICE 'Verified that column partition exists in table loggingNodes.';
		END;
		BEGIN
			ALTER TABLE "loggingNodes" ADD COLUMN "eu_range" double precision;
		EXCEPTION
			WHEN duplicate_column THEN RAISE NOTICE 'Verified that column eu_range exists in table loggingNodes.';
		END;
		BEGIN
			ALTER TABLE "loggingNodes" ADD COLUMN "store_expanded_values" INTEGER;
		EXCEPTION
			WHEN duplicate_column THEN RAISE NOTICE 'Verified that column store_expanded_values exists in table loggingNodes.';
		END;
		BEGIN
			ALTER TABLE "loggingNodes" ADD COLUMN "member_filters" TEXT;
		EXCEPTION
			WHEN duplicate_column THEN RAISE NOTICE 'Verified that column member_filters exists in table loggingNodes.';
		END;
		BEGIN
			ALTER TABLE "loggingNodes" ADD COLUMN "browse_name" TEXT;
		EXCEPTION
			WHEN duplicate_column THEN RAISE NOTICE 'Verified that column browse_name exists in table loggingNodes.';
		END;
		BEGIN
			ALTER TABLE "loggingNodes" ADD COLUMN "browse_path" TEXT;
		EXCEPTION
			WHEN duplicate_column THEN RAISE NOTICE 'Verified that column browse_path exists in table loggingNodes.';
		END;
		BEGIN
			ALTER TABLE public."loggingNodes" ALTER COLUMN sampling_interval TYPE double precision;
		EXCEPTION
			when others then RAISE NOTICE 'Attempt to change data type of the sampling_interval column failed, assuming it has double precision datatype already.';
		END;
		BEGIN
			ALTER TABLE public."loggingNodes" ALTER COLUMN publishing_interval TYPE double precision;
		EXCEPTION
			when others then RAISE NOTICE 'Attempt to change data type of the publishing_interval column failed, assuming it has double precision datatype already.';
		END;		
	END;

END IF;

IF NOT EXISTS (SELECT 1 FROM pg_tables WHERE schemaname = 'public' AND tablename = 'variable_groups')
	THEN CREATE TABLE variable_groups (
	"id"	SERIAL NOT NULL PRIMARY KEY,
	"name"	TEXT NOT NULL,
	"tag" TEXT,
	"description"	TEXT,
	"sampling_interval"	double precision,
	"publishing_interval"	double precision,
	"queue_size"	INTEGER,
	"discard_oldest"	BOOLEAN,
	"data_change_trigger"	INTEGER,
	"deadband_type"	INTEGER,
	"deadband_value"	REAL,
	"eu_range" double precision,
	"active"	BOOLEAN DEFAULT 'TRUE',
	"update_variables"	BOOLEAN DEFAULT 'FALSE',
	"read_from"	INTEGER,
	"read_type"	INTEGER,
	"store_expanded_values" INTEGER,
	"json"	TEXT);
ELSE
	BEGIN
		BEGIN
			ALTER TABLE variable_groups ADD COLUMN "active" BOOLEAN DEFAULT 'TRUE';
		EXCEPTION
			WHEN duplicate_column THEN RAISE NOTICE 'Verified that column active exists in table variable_groups.';
		END;
    BEGIN
			ALTER TABLE variable_groups ADD COLUMN "update_variables" BOOLEAN DEFAULT 'FALSE';
		EXCEPTION
			WHEN duplicate_column THEN RAISE NOTICE 'Verified that column update_variables exists in table variable_groups.';
		END;
		BEGIN
			ALTER TABLE variable_groups ADD COLUMN eu_range double precision DEFAULT '0';
		EXCEPTION
			WHEN duplicate_column THEN RAISE NOTICE 'Verified that column eu_range exists in table variable_groups.';
		END;
		BEGIN
			ALTER TABLE variable_groups ADD COLUMN "store_expanded_values" INTEGER;
		EXCEPTION
			WHEN duplicate_column THEN RAISE NOTICE 'Verified that column store_expanded_values exists in table variable_groups.';
		END;
		BEGIN
			ALTER TABLE public."variable_groups" ALTER COLUMN sampling_interval TYPE double precision;
		EXCEPTION
			when others then RAISE NOTICE 'Attempt to change data type of the sampling_interval column in table variable_groups failed, assuming it has double precision datatype already.';
		END;
		BEGIN
			ALTER TABLE public."variable_groups" ALTER COLUMN publishing_interval TYPE double precision;
		EXCEPTION
			when others then RAISE NOTICE 'Attempt to change data type of the publishing_interval column in table variable_groups failed, assuming it has double precision datatype already.';
		END;		
	END;
END IF;

IF NOT EXISTS (SELECT 1 FROM pg_tables WHERE schemaname = 'public' AND tablename = 'scripts')
	THEN CREATE TABLE "scripts" (
	"id"	SERIAL NOT NULL PRIMARY KEY,
	"type" INTEGER NOT NULL, 
	"name"	TEXT,
	"description" TEXT,
	"code"	TEXT,
	"json"	TEXT,
	"modified_at" timestamp without time zone,
	"modified_by" TEXT);
END IF;

BEGIN
	ALTER TABLE "scripts" ADD COLUMN "modified_at" timestamp without time zone;
EXCEPTION
  WHEN duplicate_column THEN RAISE NOTICE 'Verified that column "modified_at" exists in table scripts.';
END;

BEGIN
	ALTER TABLE "scripts" ADD COLUMN "modified_by" TEXT;
EXCEPTION
  WHEN duplicate_column THEN RAISE NOTICE 'Verified that column "modified_by" exists in table scripts.';
END;

-- create table tsdbs if not exists:
IF NOT EXISTS (SELECT 1 FROM pg_tables WHERE schemaname = 'public' AND tablename = 'tsdbs')
	THEN CREATE TABLE "tsdbs" (
	"id"	SERIAL NOT NULL PRIMARY KEY,
	"name"	TEXT NOT NULL,
	"type"	TEXT NOT NULL,
	"host"	TEXT,
	"port"	INTEGER,
	"user_name"	TEXT,
	"password"	TEXT,
	"path"	TEXT,
	"init_script"	TEXT,
	"connection_timeout"	INTEGER,
	"use_secured_mode"	BOOLEAN,
	"max_read_values"	INTEGER,
	"max_write_values"	INTEGER,
	"timeout"	INTEGER,
	"topic_name_generation_mode" INTEGER,
	"key_name_generation_mode" INTEGER,
	"max_queue_size"	INTEGER,
	"max_interval"	INTEGER,
	"modified_at"  timestamp without time zone,
	"modified_by" TEXT,
	"json"	TEXT);
END IF;	
	
-- create table instances if not exists:
IF NOT EXISTS (SELECT 1 FROM pg_tables WHERE schemaname = 'public' AND tablename = 'instances')
	THEN CREATE TABLE "instances" (
		"id" TEXT NOT NULL PRIMARY KEY,
		"name" TEXT,
		"ha_cluster_id" TEXT,
		"ha_node_id" TEXT,
    "ha_mode" INTEGER,
		"web_protocol" TEXT,
		"web_host" TEXT,
		"web_host_resolved" TEXT,
		"web_port" INTEGER,
		"web_ip_address" TEXT,
		"web_doc_root" TEXT,
		"web_number_of_threads" INTEGER,
		"config_id" INTEGER,
		"tsdb_id" INTEGER,
		"collector_enabled" BOOLEAN,
    "forwarder_enabled" BOOLEAN,
		"rest_enabled" BOOLEAN,
		"config_enabled" BOOLEAN,
		"app_log_level" INTEGER,
		"app_log_file_max_size" INTEGER,
		"app_log_file_max_number" INTEGER,
		"app_log_file_name" TEXT,
		"sdk_log_level" INTEGER,
		"sdk_log_file_max_size" INTEGER,
		"sdk_log_file_max_number" INTEGER,
		"sdk_log_file_name" TEXT,
		"sdk_io_threads" INTEGER,
		"sdk_timer_threads" INTEGER,
		"sdk_callback_threads" INTEGER,
		"sdk_pki_root_folder" TEXT,
		"sdk_self_signed_certificate" INTEGER,
		"state" INTEGER,
		"link_to_db" TEXT,
		"link_to_grafana" TEXT,
		"start_time" timestamp without time zone,
		"last_update_time" timestamp without time zone,
		"stop_time" timestamp without time zone,
		"modified_at"  timestamp without time zone,
		"modified_by" TEXT,
		"json" TEXT);
END IF;

BEGIN
	ALTER TABLE "instances" ADD COLUMN "ha_cluster_id" TEXT;
EXCEPTION
  WHEN duplicate_column THEN RAISE NOTICE 'Verified that column "ha_cluster_id" exists in table instances.';
END;
BEGIN
	ALTER TABLE "instances" ADD COLUMN "ha_node_id" TEXT;
EXCEPTION
  WHEN duplicate_column THEN RAISE NOTICE 'Verified that column "ha_node_id" exists in table instances.';
END;
BEGIN
	ALTER TABLE "instances" ADD COLUMN "ha_mode" INTEGER;
EXCEPTION
  WHEN duplicate_column THEN RAISE NOTICE 'Verified that column "ha_mode" exists in table instances.';
END;
BEGIN
	ALTER TABLE "instances" ADD COLUMN "forwarder_enabled" TEXT;
EXCEPTION
  WHEN duplicate_column THEN RAISE NOTICE 'Verified that column "forwarder_enabled" exists in table instances.';
END;

BEGIN
	ALTER TABLE "instances" ADD COLUMN "web_host_resolved" TEXT;
EXCEPTION
  WHEN duplicate_column THEN RAISE NOTICE 'Verified that column "web_host_resolved" exists in table instances.';
END;

BEGIN
	ALTER TABLE "instances" ADD COLUMN "sdk_self_signed_certificate" INTEGER;
EXCEPTION
  WHEN duplicate_column THEN RAISE NOTICE 'Verified that column "sdk_self_signed_certificate" exists in table instances.';
END;

BEGIN
	ALTER TABLE "instances" ADD COLUMN "sdk_timer_threads" INTEGER;
EXCEPTION
  WHEN duplicate_column THEN RAISE NOTICE 'Verified that column "sdk_timer_threads" exists in table instances.';
END;

-- create table config_servers if not exists:
IF NOT EXISTS (SELECT 1 FROM pg_tables WHERE schemaname = 'public' AND tablename = 'config_servers')
	THEN CREATE TABLE "config_servers" (
	"id" SERIAL NOT NULL PRIMARY KEY,
	"config_id" INTEGER NOT NULL,
	"server_id" INTEGER NOT NULL);
END IF;

-- create table configs if not exists:
IF NOT EXISTS (SELECT 1 FROM pg_tables WHERE schemaname = 'public' AND tablename = 'configs')
	THEN CREATE TABLE "configs" (
	"id" SERIAL NOT NULL PRIMARY KEY,
	"name" TEXT NOT NULL,
	"modified_at"  timestamp without time zone,
	"modified_by" TEXT,
	"json" TEXT);
END IF;

-- create table iam_settings if does not exist:
IF NOT EXISTS (SELECT 1 FROM pg_tables WHERE schemaname = 'public' AND tablename = 'iam_settings')
	THEN CREATE TABLE "iam_settings" (
	"id"SERIAL NOT NULL PRIMARY KEY,
	"type"	TEXT NOT NULL,
	"session_timeout" INTEGER,
	"json"	TEXT NOT NULL);
END IF;

-- create table iam_users if does not exist:
IF NOT EXISTS (SELECT 1 FROM pg_tables WHERE schemaname = 'public' AND tablename = 'iam_users')
	THEN CREATE TABLE "iam_users" (
	"id" TEXT NOT NULL PRIMARY KEY,
	"name"	TEXT NOT NULL,
	"code1" TEXT NOT NULL,
	"code2" TEXT NOT NULL,
	"active" BOOLEAN,
	"role" TEXT NOT NULL);
END IF;

END
$$;