function getHelpAndLinksMenu() {
  return {
    id: "3",
    name: "Help and Links",
    icon: "help",
    items:
      [
        {
          id: "3_0",
          name: "User Manual (local)",
          type: "link",
          url: "user-manual/index.html"
        },
        {
          id: "3_1",
          name: "User Manual (online)",
          type: "link",
          url: "https://onewayautomation.com/visual-logger-docs/html/index.html"
        },
        {
          id: "3_2",
          name: "Contact us for support",
          type: "link",
          url: "https://onewayautomation.com/index.php/contact-us"
        },
        {
          id: "3_3",
          name: "ogamma Visual Logger for OPC page at GitHub",
          type: "link",
          url: "https://github.com/onewayautomation/ogamma-logger"
        },

        {
          id: "3_4",
          name: "ogamma Visual Logger for OPC Docker image",
          type: "link",
          url: "https://hub.docker.com/r/ogamma/logger"
        },
        {
          id: "3_5",
          name: "Release Notes",
          type: "link",
          request: "ReleaseNotes.html"
        },
        {
          id: "3_6",
          name: "OPC UA Online Reference",
          type: "link",
          url: "https://reference.opcfoundation.org"
        }
      ]
  };
}

function getMainMenuData() {
  if (getSessionContext().loggedIn)
    return [
      {
        id: "0",
        name: "License",
        items:
          [
            {
              id: "0_1",
              name: "Status",
              type: "dialog",
              request: "license",
              requiresAuthentication: true
            },
            {
              id: "0_2",
              name: "Offline Activation page at License Portal",
              type: "link",
              url: "https://www.softworkz.com/offline/offline.aspx"
            },
            {
              id: "0_3",
              name: "My License Portal",
              type: "link",
              url: "https://www.softworkz.com/mylicense"
            },
            {
              id: "0.4",
              name: "One-Way Automation online store",
              type: "link",
              url: "https://onewayautomation.com/online-store"
            },
            {
              id: "0_5",
              name: "License Agreement",
              type: "link",
              request: "License.txt"
            }
          ]
      },
      {
        id: "1",
        name: "Settings",
        icon: "preferences",
        items: [
          {
            id: "1_1",
            name: "Connection to the Configuration Database",
            type: "dialog",
            request: "configDb",
            requiresAuthentication: true
          },
          {
            id: "1_2",
            name: "Collector Configurations",
            type: "dialog",
            request: "appConfigs",
            requiresAuthentication: true
          },
          {
            id: "1_3",
            name: "Time-Series Databases",
            type: "dialog",
            request: "tsdb",
            requiresAuthentication: true
          },
          {
            id: "1.4",
            name: "Instances",
            type: "dialog",
            request: "instances",
            requiresAuthentication: true
          },
          {
            id: "1.5",
            name: "Variable Groups",
            type: "dialog",
            request: "groups",
            requiresAuthentication: true
          },
					{
            id: "1.6",
            name: "Scripts",
            type: "dialog",
            request: "scripts",
            requiresAuthentication: true
          },
          {
            id: "1.7",
            name: "Certificates Management",
            type: "dialog",
            request: "trustList",
            requiresAuthentication: true
          },
          {
            id: "1.8",
            name: "Download Certificate",
            items: [
              {
                id: "1.8.1",
                name: "Application Instance Certificate",
                type: "link",
                request: "cert/app-cert.der",
                requiresAuthentication: true
              },
              {
                id: "1.8.2",
                name: "CA Certificate",
                type: "link",
                request: "cert/ca-cert.der",
                requiresAuthentication: true
              },
              {
                id: "1.8.3",
                name: "CA CRL",
                type: "link",
                request: "cert/ca-crl.crl",
                requiresAuthentication: true
              }
            ]
          }
        ]
      }

      ,
      {
        id: "2",
        name: "Tools",
        icon: "toolbox",
        items:
          [
            {
              id: "2_1",
              name: "Visualize with Grafana",
              type: "link",
              request: "grafana"
            },
            {
              id: "2_2",
              name: "Analyze with Time-Series DB manager",
              type: "link",
              request: "tsdbAdmin"
            },
            {
              id: "2_3",
              name: "Application Logs",
              type: "link",
              request: "log/app"
            },
            {
              id: "2_4",
              name: "OPC UA SDK Logs",
              type: "link",
              request: "log/sdk"
            },
            {
              id: "2_5",
              name: "Browser Logs",
              type: "link",
              request: "log/browser"
            },
            {
              id: "2_6",
              name: "Statistics",
              type: "dialog",
              request: "showStatus",
              requiresAuthentication: true
            }
          ]
      },
      getHelpAndLinksMenu(),
      {
        id: "4",
        name: "Account",
        icon: "user",
        items: getSessionMenuItems()
      }
    ];
  else
    return [
      getHelpAndLinksMenu(),
      {
        id: "4",
        name: "Login",
        icon: "user",
        type: "dialog",
        request: "login"
      }
    ];
}
