#!/bin/bash
set -e

# Determine the absolute path of the script directory
APP_DIR="$(cd "$(dirname "$0")" && pwd)"
TEMPLATE_FILE="$APP_DIR/ovl.service.in"
SERVICE_FILE="/etc/systemd/system/ovl.service"
CURRENT_USER=$USER

echo "Installing OVL service..."
echo "Application directory: $APP_DIR"
echo "User: $CURRENT_USER"

# Replace placeholder with actual path and write to /etc/systemd/system
sudo bash -c "sed 's|{{APP_PATH}}|$APP_DIR|g; s|{{USER}}|$CURRENT_USER|g' \"$TEMPLATE_FILE\" > \"$SERVICE_FILE\""

# Set proper permissions
sudo chmod 644 "$SERVICE_FILE"

# Reload systemd and enable service
sudo systemctl daemon-reload
sudo systemctl enable ovl.service

echo "OVL Service installed successfully. You can start it with:"
echo "  sudo systemctl start ovl.service"

echo "To view service log, run command:"
echo "journalctl -u ovl.service -n 50"