/* Before executing this script, replace [TableName] to the table name in SQL database (default is values) */
CREATE TABLE IF NOT EXISTS "[TableName]" (
	"time"	TEXT,
	"sourceid"	INTEGER,
	"status" INTEGER,
	"data_type" INTEGER DEFAULT 0,
	"value"	REAL DEFAULT NULL,
	"int_value" INTEGER DEFAULT NULL,
	"string_value" TEXT DEFAULT NULL,
	"client_time"	TEXT);

ALTER TABLE '[TableName]' ADD COLUMN data_type INTEGER DEFAULT 0;
ALTER TABLE '[TableName]' ADD COLUMN int_value INTEGER DEFAULT NULL;
ALTER TABLE '[TableName]' ADD COLUMN string_value TEXT DEFAULT NULL;
ALTER TABLE '[TableName]' ADD COLUMN client_time TEXT DEFAULT NULL;

CREATE UNIQUE INDEX IF NOT EXISTS idx_values_sourceid_time ON '[TableName]' (sourceid, time);