/* Before executing this script, replace [TableName] to the table name in SQL database (default is values) */
if not exists (select * from sysobjects where name='[TableName]' and xtype='U')
	BEGIN
    create table dbo."[TableName]" (
        time datetime2(3), sourceid int, status int, data_type TINYINT DEFAULT 0, value REAL DEFAULT NULL, double_value FLOAT DEFAULT NULL, int_value BIGINT DEFAULT NULL, string_value VARCHAR(MAX) DEFAULT NULL,  client_time datetime2(3)
    );
		create unique index idx_values_sourceid_time on dbo."[TableName]" (sourceid, time) WITH ( IGNORE_DUP_KEY = ON );
	END;
-- Do not create index if the table already exists.
-- if not exists (select * from sysindexes
--  where id=object_id('[TableName]') and name='idx_values_sourceid_time')
--    create unique index idx_values_sourceid_time on dbo."[TableName]" (sourceid, time) WITH ( IGNORE_DUP_KEY = ON );

IF NOT EXISTS (
  SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = '[TableName]' AND COLUMN_NAME = 'data_type')
BEGIN
  ALTER TABLE dbo."[TableName]" ADD data_type TINYINT DEFAULT 0;
END;

IF NOT EXISTS (
  SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = '[TableName]' AND COLUMN_NAME = 'double_value')
BEGIN
  ALTER TABLE dbo."[TableName]" ADD double_value FLOAT DEFAULT NULL;
END;

IF NOT EXISTS (
  SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = '[TableName]' AND COLUMN_NAME = 'int_value')
BEGIN
  ALTER TABLE dbo."[TableName]" ADD int_value BIGINT DEFAULT NULL;
END;

IF NOT EXISTS (
  SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = '[TableName]' AND COLUMN_NAME = 'string_value')
BEGIN
  ALTER TABLE dbo."[TableName]" ADD string_value VARCHAR(MAX) DEFAULT NULL;
END;

IF NOT EXISTS (
  SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = '[TableName]' AND COLUMN_NAME = 'client_time')
BEGIN
  ALTER TABLE dbo."[TableName]" ADD client_time datetime2(3) DEFAULT NULL;
END;