#!/bin/bash

# This script installs Microsoft ODBC Client Drive version 18 

if [ -f /etc/os-release ]; then
    . /etc/os-release
    if [ "$ID" = "ol" ] || [ "$NAME" = "Oracle Linux Server" ]; then
        echo "Oracle Linux detected"
	# For Oracle Linux:
	dnf install -y curl unixODBC
	curl -o /etc/yum.repos.d/microsoft-prod.repo https://packages.microsoft.com/config/rhel/8/prod$
	ACCEPT_EULA=Y dnf install -y msodbcsql18
	exit 0
    fi
fi

apt-get update
apt-get install -y curl gnupg

curl https://packages.microsoft.com/keys/microsoft.asc | \
  gpg --dearmor | \
  tee /usr/share/keyrings/microsoft-prod.gpg > /dev/null

curl https://packages.microsoft.com/config/ubuntu/22.04/prod.list | \
  sed 's#deb #deb [arch=amd64 signed-by=/usr/share/keyrings/microsoft-prod.gpg] #' | \
  tee /etc/apt/sources.list.d/mssql-release.list

echo "deb [arch=amd64 signed-by=/usr/share/keyrings/microsoft-prod.gpg] https://packages.microsoft.com/ubuntu/22.04/prod jammy main" | tee /etc/apt/sources.list.d/mssql-release.list

apt-get update
ACCEPT_EULA=Y apt-get install -y msodbcsql18
apt remove -y msodbcsql17

#optional
ACCEPT_EULA=Y apt-get install -y mssql-tools unixodbc
