/* Before executing this script, replace [TableName] to the table name in SQL database (default is values) */
CREATE TABLE IF NOT EXISTS [databaseName].[TableName] (
 time TIMESTAMP(3),
 sourceid INT, 
 status INT, 
 data_type TINYINT UNSIGNED,
 value FLOAT, 
 double_value DOUBLE PRECISION,
 int_value BIGINT,
 string_value TEXT,
 client_time TIMESTAMP(3)
 );

SELECT count(*)
INTO @exist
FROM information_schema.columns 
WHERE table_schema = database()
and COLUMN_NAME = 'data_type'
AND table_name = '[TableName]';
set @query = IF(@exist <= 0, 'ALTER TABLE [databaseName].[TableName] ADD COLUMN data_type TINYINT UNSIGNED DEFAULT 0;', 
'select \'Column data_type exists\' status');
prepare stmt from @query;
EXECUTE stmt;

SELECT count(*)
INTO @exist
FROM information_schema.columns 
WHERE table_schema = database()
and COLUMN_NAME = 'double_value'
AND table_name = '[TableName]';
set @query = IF(@exist <= 0, 'ALTER TABLE [databaseName].[TableName] ADD COLUMN double_value DOUBLE PRECISION DEFAULT NULL;', 
'select \'Column data_type exists\' status');
prepare stmt from @query;
EXECUTE stmt;

SELECT count(*)
INTO @exist
FROM information_schema.columns 
WHERE table_schema = database()
and COLUMN_NAME = 'int_value'
AND table_name = '[TableName]';
set @query = IF(@exist <= 0, 'ALTER TABLE [databaseName].[TableName] ADD COLUMN int_value BIGINT DEFAULT NULL;', 
'select \'Column int_value exists\' status');
prepare stmt from @query;
EXECUTE stmt;

SELECT count(*)
INTO @exist
FROM information_schema.columns 
WHERE table_schema = database()
and COLUMN_NAME = 'string_value'
AND table_name = '[TableName]';
set @query = IF(@exist <= 0, 'ALTER TABLE [databaseName].[TableName] ADD COLUMN string_value TEXT DEFAULT NULL;', 
'select \'Column string_value exists\' status');
prepare stmt from @query;
EXECUTE stmt;

SELECT count(*)
INTO @exist
FROM information_schema.columns 
WHERE table_schema = database()
and COLUMN_NAME = 'client_time'
AND table_name = '[TableName]';
set @query = IF(@exist <= 0, 'ALTER TABLE [databaseName].[TableName] ADD COLUMN client_time TIMESTAMP(3) DEFAULT NULL;', 
'select \'Column string_value exists\' status');
prepare stmt from @query;
EXECUTE stmt;

set @x := (select count(*) from information_schema.statistics where table_name = '[TableName]' and index_name = 'idx_values_sourceid_time' and table_schema = database());
set @sql := if( @x > 0, 'select ''Index exists.''', 'Alter Table [databaseName].[TableName] ADD CONSTRAINT UNIQUE INDEX idx_values_sourceid_time (sourceid, time);');

PREPARE stmt FROM @sql;
EXECUTE stmt;

