/*
 * Decompiled with CFR 0.152.
 */
package com.opcfy.logger.kafka;

import com.opcfy.logger.kafka.OpcUaKafkaSourceConnectorConfigDef;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigException;

public class OpcUaKafkaSourceConnectorConfig
extends AbstractConfig {
    public void validate() throws ConfigException {
        if (!this.ovlProtocol().equals("http") && !this.ovlProtocol().equals("https")) {
            throw new ConfigException("Invalid protocol: " + this.ovlProtocol());
        }
        if (this.processExitWaitTimeout() < 5000L) {
            throw new ConfigException("Invalid option opcua.connector.wait.process.stop.timeout.ms (less than 5000 ms");
        }
    }

    private String IntToString(Integer value) {
        if (value > 0) {
            return value.toString();
        }
        return "";
    }

    public OpcUaKafkaSourceConnectorConfig(Map<String, String> originals) {
        super(OpcUaKafkaSourceConnectorConfigDef.configDef(), originals);
    }

    public String workDir() {
        return this.getString("opcua.connector.work.dir");
    }

    public String executableName() {
        return this.getString("opcua.connector.executable.name");
    }

    public String topic() {
        return this.getString("opcua.connector.out.topic");
    }

    public String haTopic() {
        String t = this.getString("opcua.connector.ha.out.topic");
        if (t == null || t == "") {
            t = this.topic();
        }
        return t;
    }

    public long pollIntervalMs() {
        return this.getLong("opcua.connector.poll.interval.ms");
    }

    public boolean healthcheckEnabled() {
        return this.getBoolean("opcua.connector.healthcheck.enabled");
    }

    public long healthcheckIntervalMs() {
        return this.getLong("opcua.connector.healthcheck.interval.ms");
    }

    public String ovlConfigDbType() {
        return this.getString("opcua.connector.configdb.type");
    }

    public String ovlConfigDbHost() {
        return this.getString("opcua.connector.configdb.host");
    }

    public String ovlConfigDbPort() {
        return this.IntToString(this.getInt("opcua.connector.configdb.port"));
    }

    public String ovlConfigDbUsername() {
        return this.getString("opcua.connector.configdb.username");
    }

    public String ovlConfigDbPwd() {
        return this.getPassword("opcua.connector.configdb.pwd").value();
    }

    public String ovlConfigDbPath() {
        return this.getString("opcua.connector.configdb.path");
    }

    public String ovlProtocol() {
        return this.getString("opcua.connector.protocol");
    }

    public String ovlPort() {
        return this.IntToString(this.getInt("opcua.connector.port"));
    }

    public Boolean haEnabled() {
        return this.getBoolean("opcua.connector.ha.cluster.enabled");
    }

    public String haDbClusterId() {
        return this.getString("opcua.connector.ha.cluster.id");
    }

    public String haNodeId() {
        return this.getString("opcua.connector.ha.node.id");
    }

    public String haPriority() {
        return this.IntToString(this.getInt("opcua.connector.ha.priority"));
    }

    public String haDbHost() {
        return this.getString("opcua.connector.ha.db.host.name");
    }

    public String haDbPort() {
        return this.IntToString(this.getInt("opcua.connector.ha.db.port.number"));
    }

    public String haDbUser() {
        return this.getString("opcua.connector.ha.db.user");
    }

    public String haDbPassword() {
        return this.getPassword("opcua.connector.ha.db.password").value();
    }

    public String haDbName() {
        return this.getString("opcua.connector.ha.db.name");
    }

    public String haDbTableName() {
        return this.getString("opcua.connector.ha.db.table.name");
    }

    public String haHealthCheckInterval() {
        return this.IntToString(this.getInt("opcua.connector.ha.health.check.interval"));
    }

    public String haHealthCheckTimeout() {
        return this.IntToString(this.getInt("opcua.connector.ha.health.check_.timeout"));
    }

    public String haMaxHealthCheckFailures() {
        return this.IntToString(this.getInt("opcua.connector.ha.max.health.check.failures"));
    }

    public String haHeartbeatInterval() {
        return this.IntToString(this.getInt("opcua.connector.ha.heartbeat.interval"));
    }

    public String haHeartbeatTimeout() {
        return this.IntToString(this.getInt("opcua.connector.ha.heartbeat.timeout"));
    }

    public boolean checkIfProcessRunningAtStart() {
        return this.getBoolean("opcua.connector.check.process.on.start");
    }

    public long processExitWaitTimeout() {
        return this.getLong("opcua.connector.wait.process.stop.timeout.ms");
    }
}

