/*
 * Decompiled with CFR 0.152.
 */
package com.opcfy.logger.kafka;

import org.apache.kafka.common.config.ConfigDef;

public class OpcUaKafkaSourceConnectorConfigDef {
    public static final String OVL_WORK_DIR_CONFIG = "opcua.connector.work.dir";
    public static final String OVL_EXECUTABLE_NAME_CONFIG = "opcua.connector.executable.name";
    public static final String OVL_CHECK_PROCESS_ON_START = "opcua.connector.check.process.on.start";
    public static final String OVL_WAIT_PROCESS_STOP = "opcua.connector.wait.process.stop.timeout.ms";
    public static final String TOPIC_CONFIG = "opcua.connector.out.topic";
    public static final String HA_TOPIC_CONFIG = "opcua.connector.ha.out.topic";
    public static final String POLL_INTERVAL_MS_CONFIG = "opcua.connector.poll.interval.ms";
    public static final String HEALTHCHECK_ENABLED_CONFIG = "opcua.connector.healthcheck.enabled";
    public static final String HEALTHCHECK_INTERVAL_MS_CONFIG = "opcua.connector.healthcheck.interval.ms";
    public static final String OVL_CONFIGDB_TYPE_CONFIG = "opcua.connector.configdb.type";
    public static final String OVL_CONFIGDB_HOST_CONFIG = "opcua.connector.configdb.host";
    public static final String OVL_CONFIGDB_PORT_CONFIG = "opcua.connector.configdb.port";
    public static final String OVL_CONFIGDB_USERNAME_CONFIG = "opcua.connector.configdb.username";
    public static final String OVL_CONFIGDB_PWD_CONFIG = "opcua.connector.configdb.pwd";
    public static final String OVL_CONFIGDB_PATH_CONFIG = "opcua.connector.configdb.path";
    public static final String OVL_PROTOCOL_CONFIG = "opcua.connector.protocol";
    public static final String OVL_PORT_CONFIG = "opcua.connector.port";
    public static final String HA_CLUSTER_ENABLED = "opcua.connector.ha.cluster.enabled";
    public static final String HA_CLUSTER_ID = "opcua.connector.ha.cluster.id";
    public static final String HA_NODE_ID = "opcua.connector.ha.node.id";
    public static final String HA_PRIORITY = "opcua.connector.ha.priority";
    public static final String HA_DB_HOSTNAME = "opcua.connector.ha.db.host.name";
    public static final String HA_DB_PORT = "opcua.connector.ha.db.port.number";
    public static final String HA_DB_USER = "opcua.connector.ha.db.user";
    public static final String HA_DB_PASSWORD = "opcua.connector.ha.db.password";
    public static final String HA_DB_NAME = "opcua.connector.ha.db.name";
    public static final String HA_DB_TABLENAME = "opcua.connector.ha.db.table.name";
    public static final String HA_HEALTH_CHECK_INTERVAL = "opcua.connector.ha.health.check.interval";
    public static final String HA_HEALTH_CHECK_TIMEOUT = "opcua.connector.ha.health.check_.timeout";
    public static final String HA_MAX_HEALTH_CHECK_FAILURES = "opcua.connector.ha.max.health.check.failures";
    public static final String HA_HEARTBEAT_INTERVAL = "opcua.connector.ha.heartbeat.interval";
    public static final String HA_HEARTBEAT_TIMEOUT = "opcua.connector.ha.heartbeat.timeout";

    public static ConfigDef configDef() {
        return new ConfigDef().define(OVL_WORK_DIR_CONFIG, ConfigDef.Type.STRING, (Object)"/home/appuser/opcua/connector", ConfigDef.Importance.HIGH, "Work directory where OPC Ua Source Connector will be extracted and executed").define(OVL_EXECUTABLE_NAME_CONFIG, ConfigDef.Type.STRING, (Object)"start-ogamma-logger.sh", ConfigDef.Importance.MEDIUM, "Executable or script name to run").define(TOPIC_CONFIG, ConfigDef.Type.STRING, (Object)"opcua-connector-out", ConfigDef.Importance.HIGH, "Topic name to redirect OPC UA Connector console output messages").define(HA_TOPIC_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.HIGH, "Topic name to redirect console output messages of the HA Service for the OPC UA Connector. If empty, messages are redirected to the same topic as for the connector.").define(OVL_CONFIGDB_TYPE_CONFIG, ConfigDef.Type.STRING, (Object)"SQLite", ConfigDef.Importance.MEDIUM, "Type of the database to store configuration settings: SQLite or PostgreSQL").define(OVL_CONFIGDB_HOST_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, "Host name of the PostgreSQL database. Not used if the database type is SQLite.").define(OVL_CONFIGDB_PORT_CONFIG, ConfigDef.Type.INT, (Object)0, ConfigDef.Importance.MEDIUM, "Port number of the PostgreSQL database. Not used if the database type is SQLite.").define(OVL_CONFIGDB_USERNAME_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, "UserName to connect to the PostgreSQL database. Not used if the database type is SQLite.").define(OVL_CONFIGDB_PWD_CONFIG, ConfigDef.Type.PASSWORD, (Object)"", ConfigDef.Importance.MEDIUM, "Password to connect to the PostgreSQL database. Not used if the database type is SQLite.").define(OVL_CONFIGDB_PATH_CONFIG, ConfigDef.Type.STRING, (Object)"./data/config.db", ConfigDef.Importance.MEDIUM, "File name of the SQLite database (if the type is SQLite), or database name (if the type is PostgreSQL).").define(OVL_PROTOCOL_CONFIG, ConfigDef.Type.STRING, (Object)"http", ConfigDef.Importance.MEDIUM, "Protocol of the OPC UA Connector Configuration endpoint: http or https").define(OVL_PORT_CONFIG, ConfigDef.Type.INT, (Object)4880, ConfigDef.Importance.MEDIUM, "Port Number of the OPC UA Connector configiration endpoint.").define(POLL_INTERVAL_MS_CONFIG, ConfigDef.Type.LONG, (Object)10000L, ConfigDef.Importance.MEDIUM, "Interval of polling wrapped OPC UA producer in milliseconds").define(HEALTHCHECK_ENABLED_CONFIG, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, "Enable healthcheck of the wrapped OPC UA  Producer").define(HEALTHCHECK_INTERVAL_MS_CONFIG, ConfigDef.Type.LONG, (Object)5000L, ConfigDef.Importance.LOW, "Healthcheck interval in milliseconds").define(OVL_CHECK_PROCESS_ON_START, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, "At start check if the previous OPC UA Producer process stopped. Appied at connector task restart.").define(OVL_WAIT_PROCESS_STOP, ConfigDef.Type.LONG, (Object)60000L, ConfigDef.Importance.LOW, "Duration in milliseconds to wait for stop of the previous OPC UA Producer process.").define(HA_CLUSTER_ENABLED, ConfigDef.Type.BOOLEAN, (Object)"false", ConfigDef.Importance.HIGH, "True if this node is member node of the High Availability (HA) Cluster. Other HA options (excepting Cluster Id and Node Id) are applicable only when this option is False.").define(HA_CLUSTER_ID, ConfigDef.Type.STRING, (Object)"ha_cluster_1", ConfigDef.Importance.HIGH, "ID of the HA cluster. This field is also used in log messages redirected to the Kafka topic.").define(HA_NODE_ID, ConfigDef.Type.STRING, (Object)"node_1", ConfigDef.Importance.HIGH, "ID of this node in the HA cluster. This field is also used in log messages redirected to the Kafka topic..").define(HA_PRIORITY, ConfigDef.Type.INT, (Object)"100", ConfigDef.Importance.MEDIUM, "Priority of the node. If all nodes are operational, then the node with the highest priority bemoces an Active node.").define(HA_DB_HOSTNAME, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, "Host name of the database used to exchange HA hearbeat messages").define(HA_DB_PORT, ConfigDef.Type.INT, (Object)0, ConfigDef.Importance.MEDIUM, "Port number of the database used to exchange HA hearbeat messages").define(HA_DB_USER, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, "User name to connect to the database used to exchange HA hearbeat messages").define(HA_DB_PASSWORD, ConfigDef.Type.PASSWORD, (Object)"", ConfigDef.Importance.MEDIUM, "Password to connect to the database used to exchange HA hearbeat messages").define(HA_DB_NAME, ConfigDef.Type.STRING, (Object)"ovlhadb", ConfigDef.Importance.MEDIUM, "Name of the database used to exchange HA hearbeat messages").define(HA_DB_TABLENAME, ConfigDef.Type.STRING, (Object)"nodes", ConfigDef.Importance.MEDIUM, "Name of the table in the database used to exchange HA hearbeat messages").define(HA_HEALTH_CHECK_INTERVAL, ConfigDef.Type.INT, (Object)1000, ConfigDef.Importance.MEDIUM, "Interval (in ms) to check health of the wrapped OPC UA Source Connector application").define(HA_HEALTH_CHECK_TIMEOUT, ConfigDef.Type.INT, (Object)1000, ConfigDef.Importance.MEDIUM, "Timeout (in ms) of the application health check calls").define(HA_MAX_HEALTH_CHECK_FAILURES, ConfigDef.Type.INT, (Object)3, ConfigDef.Importance.MEDIUM, "Number of consecutive failures of application health check calls after which the application is considered as failed").define(HA_HEARTBEAT_INTERVAL, ConfigDef.Type.INT, (Object)1000, ConfigDef.Importance.MEDIUM, "Interval to publish HA heartbeat messages in the database").define(HA_HEARTBEAT_TIMEOUT, ConfigDef.Type.INT, (Object)1000, ConfigDef.Importance.MEDIUM, "Time elapsed since the last published hearbeat message, after which the node is considered as failed.");
    }
}

